<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Základní staničení Příčný sklon</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis Základní staničení Příčný sklon</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right">Směrová základní trasa:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="HorizontalAlignment/@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right">Výšková trasa:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="HorizontalAlignment/VerticalAlignment/@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />

                                <table class="margin" cellpadding="2" cellspacing="1" width="90%">
                                    <thead>
                                        <tr>
                                            <th class="underline" align="right" lang="en">Staničení</th>
                                            <th class="underline" align="right" lang="en">Z Terén</th>
                                            <th class="underline" align="right" lang="en">Z Návrh</th>
                                            <th class="underline" align="right" lang="en">Y</th>
                                            <th class="underline" align="right" lang="en">X</th>
                                            <th class="underline" align="right" lang="en">Sklon</th>
                                            <th class="underline" align="right" lang="en">Příčný sklon</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="//StationOffsetPoint">
                                            <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                                                <tr>
                                                    <td colspan="4" lang="en">
                                                        <strong>
                                                            <br/>Odstup trasa: &#xa0;
                                                        </strong>
                                                        <xsl:value-of select="@offsetAlignmentName"/>
                                                        <br/>
                                                    </td>
                                                </tr>
                                            </xsl:if>
                                            <tr>
                                                <td class="sidepad" align="right" nowrap="nowrap">
                                                    <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/@existingElevation))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@elevation))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@northing))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@easting))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:gradeFormat(number(centerLinePoint/@instantaneousGrade))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:gradeFormat(number(centerLinePoint/@crossSlope))"/>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis použijte Civil Nástroje a Výpis Základní staničení. Vyberte základní trasu a dva další geometrické prvky.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
